;==========================================================================
;Version history:
;==========================================================================
;2010/01/14     First edition
;==========================================================================
        .INCLUDE        Inc\Input.inc
;==========================================================================
        .CODE
;==========================================================================
F_ServiceInput:
        LDA     P_InputData             ;Get input status
        LDX     R_InputDebounce
        STA     R_InputDebounce
        CPX     R_InputDebounce
        BEQ     L_StableTwoSample?
        SEI
        LDA     #D_InputDebounceLevel+80H
        STA     R_InputDebounceCnt
        CLI
        RTS
L_StableTwoSample?:
        LDA     R_InputDebounceCnt
        BPL     L_ServiceExit?
        SEI
        LDA     R_InputDebounceCnt
        AND     #01111111B
        BEQ     L_InputStable
        CLI
L_ServiceExit?:
        RTS

L_InputStable:
        SEI
        LDA     R_InputDebounceCnt
        AND     #01111111B
        STA     R_InputDebounceCnt
        CLI

        LDX     R_InputDebounce         ;Current input data
        LDA     R_KeyBuf                ;Last input data
        STA     R_InputTemp
        STX     R_KeyBuf
        EOR     R_KeyBuf
        TAX
        AND     R_KeyBuf
        ORA     R_KeyStroke
        STA     R_KeyStroke
        TXA
        AND     R_InputTemp
        ORA     R_KeyRelease
        STA     R_KeyRelease
        RTS
;==========================================================================
;Purpose: Get input event on designated I/O port
;Input: None
;Return: C = 0, no input; C = 1, a input event is issued
;        A = Input (Press: 00H, 01H,K07H; Release: 80H, 81H,K87H)
;Destroy: A, X
;Note: "Press" means an I/O is triggered to high level
;==========================================================================
F_GetInput:
        LDA     R_KeyStroke
        BNE     L_ChkInputStroke        ;If not 0, depress
        LDA     R_KeyRelease
        BEQ     L_ExitGetInput
L_ChkInputRelease:
        LDX     #07H
L_Loop?:
        ROL     A                       ;Convert to 00~07H
        BCS     L_GetInputRelease
        DEX
        BPL     L_Loop?
        BMI     L_ExitGetInput
L_GetInputRelease:
        LDA     T_InputBitMask,X
        AND     R_KeyRelease
        STA     R_KeyRelease
        TXA
        ORA     #80H                    ;Convert to 80~87H
        BNE     L_InputValid
L_ChkInputStroke:
        LDX     #07H
L_Loop?:
        ROL     A                       ;Convert to 00~07H
        BCS     L_GetInputStroke
        DEX
        BPL     L_Loop?
L_ExitGetInput:
        CLC
        RTS

L_GetInputStroke:
        LDA     T_InputBitMask,X
        AND     R_KeyStroke
        STA     R_KeyStroke
        TXA
L_InputValid:
        SEC
        RTS
;==========================================================================
T_InputBitMask:
        DB      11111110B               ;0
        DB      11111101B               ;1
        DB      11111011B               ;2
        DB      11110111B               ;3
        DB      11101111B               ;4
        DB      11011111B               ;5
        DB      10111111B               ;6
        DB      01111111B               ;7
;==========================================================================
